/*
 * Decompiled with CFR 0.152.
 */
package morph.avaritia.compat.jei;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.mojang.blaze3d.vertex.PoseStack;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import morph.avaritia.api.CompressorRecipe;
import morph.avaritia.client.gui.NeutroniumCompressorScreen;
import morph.avaritia.compat.jei.AvaritiaJEIPlugin;
import morph.avaritia.init.AvaritiaModContent;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class CompressorRecipeCategory
implements IRecipeCategory<CompressorRecipe> {
    private final IDrawable background;
    private final IDrawable icon;
    private final LoadingCache<Integer, IDrawableAnimated> singularities;

    public CompressorRecipeCategory(final IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(NeutroniumCompressorScreen.TEXTURE, 37, 29, 102, 41);
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)AvaritiaModContent.COMPRESSOR_BLOCK.get()));
        this.singularities = CacheBuilder.newBuilder().maximumSize(25L).build((CacheLoader)new CacheLoader<Integer, IDrawableAnimated>(){

            public IDrawableAnimated load(Integer key) {
                return guiHelper.drawableBuilder(NeutroniumCompressorScreen.TEXTURE, 176, 16, 16, 16).buildAnimated(Math.max(key / 16, 1), IDrawableAnimated.StartDirection.BOTTOM, false);
            }
        });
    }

    public void draw(CompressorRecipe recipe, IRecipeSlotsView recipeSlotsView, PoseStack pStack, double mouseX, double mouseY) {
        IDrawableAnimated singularity = (IDrawableAnimated)this.singularities.getUnchecked((Object)recipe.getCost());
        singularity.draw(pStack, 53, 6);
        String thing = "Input Amount: " + recipe.getCost();
        Font font = Minecraft.m_91087_().f_91062_;
        font.m_92883_(pStack, thing, (float)(this.background.getWidth() / 2 - font.m_92895_(thing) / 2), 31.0f, 0x404040);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, CompressorRecipe recipe, IFocusGroup focuses) {
        IRecipeSlotBuilder input = builder.addSlot(RecipeIngredientRole.INPUT, 2, 6);
        recipe.m_7527_().forEach(arg_0 -> ((IRecipeSlotBuilder)input).addIngredients(arg_0));
        builder.addSlot(RecipeIngredientRole.OUTPUT, 80, 6).addItemStack(recipe.m_8043_());
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public Component getTitle() {
        return NeutroniumCompressorScreen.TITLE;
    }

    public ResourceLocation getUid() {
        return this.getRecipeType().getUid();
    }

    public Class<? extends CompressorRecipe> getRecipeClass() {
        return this.getRecipeType().getRecipeClass();
    }

    public RecipeType<CompressorRecipe> getRecipeType() {
        return AvaritiaJEIPlugin.COMPRESSOR_TYPE;
    }
}

